function H = h_LWLS(Y,idx_V,idx_I)
% H = h_LWLS(Y,idx_V,idx_I)
%
% INPUT
% - Y       Nodal admittance matrix.
% - idx_V   Locations of voltage phasor measurements.
% - idx_I   Locations of current phasor measurements.
%
% OUTPUT
% - H       Jacobian matrix of the linear measurement function.

n_SE = size(Y,1); % Number of voltage phasor estimates.

%% Jacobian matrix

% Voltage measurements

% ******************************
% ! Write your own code here !
% ******************************

dVre_dVre = [];
dVre_dVim = [];
dVim_dVre = [];
dVim_dVim = [];

% ******************************

% Current measurements

% ******************************
% ! Write your own code here !
% ******************************

G = real(Y);
B = imag(Y);

dIre_dVre = [];
dIre_dVim = [];
dIim_dVre = [];
dIim_dVim = [];

% ******************************

H = [dVre_dVre,dVre_dVim;dVim_dVre,dVim_dVim;dIre_dVre,dIre_dVim;dIim_dVre,dIim_dVim];

end